<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Appointment extends Model 
{

    protected $table = 'appointments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('doctor_id', 'patient_id', 'day', 'time_from', 'time_to', 'notes', 'status');

    public function doctor()
    {
        return $this->belongsTo('Models\Doctor', 'doctor_id');
    }

    public function patient()
    {
        return $this->belongsTo('Models\Patient', 'patient_id');
    }

}