<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'name', 'sale_price', 'purchase_price', 'generic_name', 'expire_date');

	public function category()
	{
		return $this->belongsTo('Models\Category', 'category_id');
	}

	public function inventories()
	{
		return $this->belongsToMany('Models\Inventory', 'inventories_products');
	}

}