<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Prescription extends Eloquent {

	protected $table = 'prescriptions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('doctor_id', 'patient_id', 'date', 'history');

	public function doctor()
	{
		return $this->belongsTo('Models\Doctor', 'doctor_id');
	}

	public function patient()
	{
		return $this->belongsTo('Models\Patient', 'patient_id');
	}

	public function items()
	{
		return $this->hasMany('Models\PrescriptionItem', 'prescription_id');
	}

}