<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LabReport extends Eloquent {

	protected $table = 'lab_reports';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('patient_id', 'doctor_id', 'date', 'details');

	public function doctor()
	{
		return $this->belongsTo('Models\Doctor', 'doctor_id');
	}

	public function patient()
	{
		return $this->belongsTo('Models\Patient', 'patient_id');
	}

}