<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InvoicePayment extends Eloquent {

	protected $table = 'invoice_payments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('invoice_id', 'patient_id', 'amount', 'date', 'notes');

	public function invoice()
	{
		return $this->hasMany('Models\Invoice', 'invoice_id');
	}

}