<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InventoryProduct extends Eloquent {

	protected $table = 'inventories_products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('inventory_id', 'product_id', 'quantity');

	public function product()
	{
		return $this->belongsTo('Models\Product', 'product_id');
	}

	public function inventory()
	{
		return $this->belongsTo('Models\Inventory', 'inventory_id');
	}

}