<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BedAllotment extends Eloquent {

	protected $table = 'bed_allotments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('patient_id', 'date_from', 'date_to', 'notes');

	public function bed()
	{
		return $this->belongsTo('Models\Bed', 'bed_id');
	}

}