<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Appointment extends Eloquent {

	protected $table = 'appointments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('doctor_id', 'patient_id', 'day', 'time_from', 'time_to', 'notes', 'status');

	public function doctor()
	{
		return $this->belongsTo('Models\Doctor', 'doctor_id');
	}

	public function patient()
	{
		return $this->belongsTo('Models\Patient', 'patient_id');
	}

}