<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->integer('age');
			$table->integer('blood_type_id')->unsigned();
			$table->integer('bags');
			$table->text('hospital_address');
			$table->integer('city_id')->unsigned();
			$table->integer('phone');
			$table->text('details');
			$table->decimal('latitude')->default('10,8');
			$table->decimal('longitude')->default('10,8');
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}