<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInfosClasseTable extends Migration {

	public function up()
	{
		Schema::create('infos_classe', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_classe')->unsigned();
			$table->integer('id_enseignant_titulaire')->unsigned()->nullable();
			$table->string('annee_academique', 255)->nullable();
			$table->integer('effectif')->nullable()->default('0');
			$table->integer('effectif_max');
			$table->boolean('etat')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('infos_classe');
	}
}