<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClassesMereTable extends Migration {

	public function up()
	{
		Schema::create('classes_mere', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nom_classe_mere', 255);
			$table->integer('id_section')->unsigned()->nullable();
			$table->enum('cycle', array('cycle1', 'cycle2'))->nullable();
			$table->boolean('etat')->default(0);
			$table->string('annee_academique', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('classes_mere');
	}
}