<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceTable extends Migration {

	public function up()
	{
		Schema::create('service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 300)->unique();
			$table->float('initial_fee')->default('0');
			$table->float('hourly_fee')->default('0');
			$table->integer('parent_id')->unsigned();
			$table->enum('activation', array('on', 'off'))->index();
			$table->integer('city')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('service');
	}
}