<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('assigned_to')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subtasks', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('tasks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_tasks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_tasks', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('tasks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_projects', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_projects', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_created_by_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_created_by_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_assigned_to_foreign');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->dropForeign('invitations_project_id_foreign');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->dropForeign('invitations_user_id_foreign');
		});
		Schema::table('invitations', function(Blueprint $table) {
			$table->dropForeign('invitations_role_id_foreign');
		});
		Schema::table('subtasks', function(Blueprint $table) {
			$table->dropForeign('subtasks_task_id_foreign');
		});
		Schema::table('user_tasks', function(Blueprint $table) {
			$table->dropForeign('user_tasks_user_id_foreign');
		});
		Schema::table('user_tasks', function(Blueprint $table) {
			$table->dropForeign('user_tasks_task_id_foreign');
		});
		Schema::table('user_projects', function(Blueprint $table) {
			$table->dropForeign('user_projects_user_id_foreign');
		});
		Schema::table('user_projects', function(Blueprint $table) {
			$table->dropForeign('user_projects_project_id_foreign');
		});
	}
}