<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Categories', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('Sections')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Variant', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Posts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Posts', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Bookmarks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Bookmarks', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ProdSales', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_category_id_foreign');
		});
		Schema::table('Categories', function(Blueprint $table) {
			$table->dropForeign('Categories_section_id_foreign');
		});
		Schema::table('Variant', function(Blueprint $table) {
			$table->dropForeign('Variant_product_id_foreign');
		});
		Schema::table('Posts', function(Blueprint $table) {
			$table->dropForeign('Posts_user_id_foreign');
		});
		Schema::table('Posts', function(Blueprint $table) {
			$table->dropForeign('Posts_product_id_foreign');
		});
		Schema::table('Orders', function(Blueprint $table) {
			$table->dropForeign('Orders_user_id_foreign');
		});
		Schema::table('Bookmarks', function(Blueprint $table) {
			$table->dropForeign('Bookmarks_user_id_foreign');
		});
		Schema::table('Bookmarks', function(Blueprint $table) {
			$table->dropForeign('Bookmarks_product_id_foreign');
		});
		Schema::table('ProdSales', function(Blueprint $table) {
			$table->dropForeign('ProdSales_product_id_foreign');
		});
	}
}