<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('coupon_id')->unsigned();
			$table->integer('store_id')->unsigned();
			$table->time('time_to');
			$table->time('time_from');
			$table->string('payment_method', 191);
			$table->integer('user_address_id')->unsigned();
			$table->integer('satus')->default('1');
			$table->integer('driver_id')->unsigned();
			$table->integer('rate');
			$table->bigInteger('item_amount');
			$table->integer('tax_amount');
			$table->integer('delivery_amount');
			$table->bigInteger('total_amount');
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}