<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderDetailsTable extends Migration {

	public function up()
	{
		Schema::create('order_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('item_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->integer('unit_price');
			$table->integer('quantity');
			$table->integer('total_price');
			$table->integer('status')->default('1');
			$table->integer('coupon_id')->unsigned();
			$table->integer('order_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('order_details');
	}
}