<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCityTable extends Migration {

	public function up()
	{
		Schema::create('city', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('country_id')->unsigned();
			$table->string('name', 191);
			$table->string('sort', 191);
			$table->integer('status')->default('1');
			$table->float('default_driver_price');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('city');
	}
}