<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppInfoTable extends Migration {

	public function up()
	{
		Schema::create('app_info', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->longText('text');
			$table->string('machine_name', 191);
			$table->integer('sort');
			$table->integer('status')->default('1');
			$table->integer('country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('app_info');
	}
}