<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeguideCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('leguide_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 5);
			$table->string('name', 255);
			$table->string('slug', 255);
			$table->string('summary', 255)->nullable();
			$table->text('description')->nullable();
			$table->integer('parent_id')->unsigned();
			$table->integer('nest_left')->nullable();
			$table->integer('nest_right')->nullable();
			$table->integer('nest_depth')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('leguide_categories');
	}
}