<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryTable extends Migration {

	public function up()
	{
		Schema::create('inventory', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->integer('available_qty');
			$table->integer('min_qty');
			$table->string('category', 1);
			$table->float('price');
			$table->string('uom', 100)->nullable();
			$table->string('is_reusable', 1);
			$table->integer('equipment_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('inventory');
	}
}