<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration {

	public function up()
	{
		Schema::create('contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->string('address', 255);
			$table->timestamp('due_date')->nullable();
			$table->timestamp('start_date');
			$table->string('is_new', 1);
			$table->string('status', 10);
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('contracts');
	}
}