<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Jobs extends Model 
{

    protected $table = 'job';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->hasOne('Customers', 'uid');
    }

    public function address()
    {
        return $this->hasOne('Address', 'aid');
    }

    public function car()
    {
        return $this->hasOne('Cars', 'cid');
    }

    public function washer()
    {
        return $this->hasOne('Washers', 'wid');
    }

    public function payment()
    {
        return $this->hasOne('Payments', 'pid');
    }

}