<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->tinyInteger('role')->default('0');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('password');
			$table->string('phone')->nullable();
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}