<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'Products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'name', 'car_id', 'model_id', 'year', 'details', 'file');

	public function user()
	{
		return $this->belongsTo('app\Users', 'user_id');
	}

	public function car()
	{
		return $this->belongsTo('app\Car');
	}

}