<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('avatar', 255)->nullable();
			$table->string('phone', 255);
			$table->enum('type', array('admin', 'user', 'seller'));
			$table->enum('status', array('new', 'active', 'block', 'closed'));
			$table->string('code', 255);
			$table->string('address', 255)->nullable();
			$table->integer('city_id');
			$table->string('lat', 255)->nullable();
			$table->string('long', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}