<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjProjectsTable extends Migration {

	public function up()
	{
		Schema::create('proj_projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id')->unsigned()->nullable();
			$table->integer('contact_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->date('starts_at')->nullable()->index();
			$table->date('ends_at')->nullable();
			$table->integer('status_id')->unsigned()->nullable();
			$table->string('name');
			$table->text('briefing')->nullable();
			$table->decimal('value', 10,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('proj_projects');
	}
}