<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('email')->nullable();
			$table->string('country')->nullable();
			$table->string('city')->nullable();
			$table->string('address')->nullable();
			$table->string('zipcode')->nullable();
			$table->string('neighborhood')->nullable();
			$table->string('phone')->nullable();
			$table->string('website')->nullable();
			$table->text('moreinfo')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}