<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'proj_projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function tasks()
	{
		return $this->hasMany('App\Task');
	}

	public function category()
	{
		return $this->belongsTo('App\ProjCategory');
	}

	public function status()
	{
		return $this->belongsTo('App\ProjStatus');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function contact()
	{
		return $this->belongsTo('App\Contact');
	}

	public function bills()
	{
		return $this->hasMany('App\Bill');
	}

}