<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bill extends Eloquent {

	protected $table = 'fin_bills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function project()
	{
		return $this->belongsTo('App\Project');
	}

	public function category()
	{
		return $this->belongsTo('App\FinCategory');
	}

	public function contact()
	{
		return $this->belongsTo('App\Contact');
	}

	public function installments()
	{
		return $this->hasMany('App\Insallment');
	}

}