<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('fin_bills', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('proj_projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fin_bills', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('fin_bills', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('fin_categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('fin_installments', function(Blueprint $table) {
			$table->foreign('bill_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('proj_projects', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('proj_categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('proj_projects', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('proj_projects', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('proj_projects', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('proj_status')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('proj_tasks', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('proj_projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('proj_tasks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('fin_bills', function(Blueprint $table) {
			$table->dropForeign('fin_bills_project_id_foreign');
		});
		Schema::table('fin_bills', function(Blueprint $table) {
			$table->dropForeign('fin_bills_contact_id_foreign');
		});
		Schema::table('fin_bills', function(Blueprint $table) {
			$table->dropForeign('fin_bills_category_id_foreign');
		});
		Schema::table('fin_installments', function(Blueprint $table) {
			$table->dropForeign('fin_installments_bill_id_foreign');
		});
		Schema::table('proj_projects', function(Blueprint $table) {
			$table->dropForeign('proj_projects_category_id_foreign');
		});
		Schema::table('proj_projects', function(Blueprint $table) {
			$table->dropForeign('proj_projects_contact_id_foreign');
		});
		Schema::table('proj_projects', function(Blueprint $table) {
			$table->dropForeign('proj_projects_user_id_foreign');
		});
		Schema::table('proj_projects', function(Blueprint $table) {
			$table->dropForeign('proj_projects_status_id_foreign');
		});
		Schema::table('proj_tasks', function(Blueprint $table) {
			$table->dropForeign('proj_tasks_project_id_foreign');
		});
		Schema::table('proj_tasks', function(Blueprint $table) {
			$table->dropForeign('proj_tasks_user_id_foreign');
		});
	}
}