<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjTasksTable extends Migration {

	public function up()
	{
		Schema::create('proj_tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->unsigned();
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('name');
			$table->text('description')->nullable();
			$table->date('starts_at')->nullable();
			$table->date('ends_at')->nullable();
			$table->datetime('finished_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('proj_tasks');
	}
}