<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products_options', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_options_values', function(Blueprint $table) {
			$table->foreign('product_option_id')->references('id')->on('products_options')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('option_values', function(Blueprint $table) {
			$table->foreign('product_option_id')->references('id')->on('products_options')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('option_values', function(Blueprint $table) {
			$table->foreign('product_option_value_id')->references('id')->on('products_options_values')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_prices', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products_price_tiers', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('custom_option_values', function(Blueprint $table) {
			$table->foreign('products_options_value_id')->references('id')->on('products_options_values')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_images', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('products_options', function(Blueprint $table) {
			$table->dropForeign('products_options_product_id_foreign');
		});
		Schema::table('products_options_values', function(Blueprint $table) {
			$table->dropForeign('products_options_values_product_option_id_foreign');
		});
		Schema::table('products_images', function(Blueprint $table) {
			$table->dropForeign('products_images_product_id_foreign');
		});
		Schema::table('option_values', function(Blueprint $table) {
			$table->dropForeign('option_values_product_option_id_foreign');
		});
		Schema::table('option_values', function(Blueprint $table) {
			$table->dropForeign('option_values_product_option_value_id_foreign');
		});
		Schema::table('products_prices', function(Blueprint $table) {
			$table->dropForeign('products_prices_product_id_foreign');
		});
		Schema::table('products_price_tiers', function(Blueprint $table) {
			$table->dropForeign('products_price_tiers_product_id_foreign');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->dropForeign('category_product_category_id_foreign');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->dropForeign('category_product_product_id_foreign');
		});
		Schema::table('custom_option_values', function(Blueprint $table) {
			$table->dropForeign('custom_option_values_products_options_value_id_foreign');
		});
		Schema::table('category_images', function(Blueprint $table) {
			$table->dropForeign('category_images_category_id_foreign');
		});
	}
}