<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsOptionsValuesTable extends Migration {

	public function up()
	{
		Schema::create('products_options_values', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_option_id')->unsigned();
			$table->integer('product_price_tier_id')->nullable();
			$table->string('sku', 255)->nullable();
			$table->integer('inventory')->default('0');
			$table->string('name', 255);
			$table->string('value', 255);
			$table->decimal('price', 9,2)->default('0.00');
			$table->tinyInteger('taxable')->default('0');
			$table->integer('sort_order')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products_options_values');
	}
}