<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryImagesTable extends Migration {

	public function up()
	{
		Schema::create('category_images', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('name', 255);
			$table->string('title', 255);
			$table->string('alt', 255);
			$table->string('link', 255)->nullable();
			$table->text('description')->nullable();
			$table->integer('sort_order');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('category_images');
	}
}