<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('order_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('client_id')->unsigned()->index();
			$table->string('client_name');
			$table->string('client_mobile');
			$table->integer('cost');
			$table->tinyInteger('status');
			$table->string('payment_method')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_transactions');
	}
}