<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('name_ar', 'name_en', 'user_id', 'brand_id', 'category_id', 'total_qty', 'color', 'specification_ar', 'specification_en', 'video', 'detail_ar', 'detail_en', 'sku', 'black_friday', 'today_deal');

	public function brand()
	{
		return $this->belongsTo('App\Models\Brand');
	}

	public function photos()
	{
		return $this->morphMany('App\Models\Photo', 'photoable');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client');
	}

	public function carts()
	{
		return $this->hasMany('App\Models\Cart');
	}

	public function DeliveryCosts()
	{
		return $this->hasMany('App\Models\DeliveryCost');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

	public function BoughtTogethers()
	{
		return $this->hasMany('App\Models\BoughtTogether');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function photo()
	{
		return $this->morphOne('App\Models\Photo', 'photoable');
	}

	public function sizes()
	{
		return $this->hasMany('App\Models\Size');
	}

}