<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('first_name', 'last_name', 'email', 'phone', 'address', 'password', 'pin_code', 'activated', 'governorate_id');
	protected $hidden = array('password');

	public function governorate()
	{
		return $this->belongsTo('App\Models\Governorate');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function shippings()
	{
		return $this->hasMany('App\Models\Shipping');
	}

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

	public function carts()
	{
		return $this->hasMany('App\Models\Cart');
	}

	public function orders()
	{
		return $this->belongsTo('App\Models\Order');
	}

}