<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'status', 'type');

	public function Profile()
	{
		return $this->hasOne('App\Profile');
	}

	public function Posts()
	{
		return $this->hasMany('App\Post', 'user_id');
	}

	public function Offers()
	{
		return $this->hasMany('App\Offer', 'user_id');
	}

	public function Works()
	{
		return $this->hasMany('App\Work', 'user_id');
	}

}