<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicalHistoryTable extends Migration {

	public function up()
	{
		Schema::create('medical_history', function(Blueprint $table) {
			$table->increments('id');
			$table->json('medical_data');
			$table->text('remarks');
			$table->boolean('is_verified')->default(False);
			$table->boolean('is_saved');
			$table->boolean('is_submitted');
			$table->bigInteger('verified_by');
			$table->bigInteger('patient_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('medical_history');
	}
}