<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChatTable extends Migration {

	public function up()
	{
		Schema::create('chat', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('sender');
			$table->datetime('start_conversation')->nullable();
			$table->datetime('end_conversation')->nullable();
			$table->datetime('end_date')->nullable();
			$table->integer('state')->nullable();
			$table->string('status')->nullable();
			$table->string('history', 1000)->nullable();
			$table->string('no_tiket')->nullable();
			$table->string('nip')->nullable();
			$table->string('status_tiket')->nullable();
			$table->string('it_support')->nullable();
			$table->string('permasalahan')->nullable();
			$table->integer('kategori_id')->nullable();
			$table->string('lokasi')->nullable();
			$table->integer('is_autoclose')->nullable();
			$table->string('call_tyoe')->nullable();
			$table->string('via')->nullable();
			$table->string('feedback')->nullable();
			$table->string('it_support_username')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('chat');
	}
}