<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfessionalProjectTable extends Migration {

	public function up()
	{
		Schema::create('professional_project', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('project_id')->unsigned();
			$table->integer('professional_id')->unsigned();
			$table->timestamps();
			$table->boolean('accepted')->default(0);
			$table->boolean('finished')->default(0);
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('professional_project');
	}
}