<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Website extends Model 
{

    protected $table = 'websites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('active', 'ip', 'phpform', 'dns_control', 'cms', 'cms_version', 'responsive', 'renewal_month', 'hosting', 'revel_care', 'launch', 'start', 'imagequestdomains', 'managed_analytics');

    public function credentials()
    {
        return $this->hasMany('App\Credential');
    }

    public function company()
    {
        return $this->hasOne('App\Company');
    }

    public function contacts()
    {
        return $this->morphMany('App\Contact', 'contactable');
    }

}