<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Credentialfield extends Model 
{

    protected $table = 'credentialfields';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('field_label');

    public function credentialtype()
    {
        return $this->belongsTo('App\Credentialtype');
    }

    public function credentials()
    {
        return $this->hasManyThrough('App\Credential', 'App\Credentialtype');
    }

}