<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function websites()
    {
        return $this->hasMany('App\Credential');
    }

    public function contacts()
    {
        return $this->morphMany('App\Contact', 'contactable');
    }

}