<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('email', 255);
			$table->integer('country_id')->unsigned();
			$table->string('password', 255);
			$table->date('birthdate');
			$table->boolean('email_verfied');
			$table->timestamp('phone_verfied');
			$table->string('middle_name', 255);
			$table->boolean('is_blocked');
			$table->string('user_name', 255);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}