<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shop extends Model 
{

    protected $table = 'shops';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'location', 'user_id');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function lists()
    {
        return $this->hasMany('List');
    }

}