<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('topic_prefix');
			$table->string('title');
			$table->integer('category_id')->unique()->unsigned();
			$table->decimal('price', 8,2);
			$table->boolean('is_physical')->default(true);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}