<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LawyerOffer extends Model 
{

    protected $table = 'lawyer_offer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function lawyer()
    {
        return $this->belongsTo('Lawyer');
    }

    public function detail()
    {
        return $this->hasMany('LawyerOfferDetail');
    }

}