<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->string('slug')->nullable();
			$table->longText('content')->nullable();
			$table->enum('status', array(''DRAFT'', ''PUBLISHED''));
			$table->integer('user_id');
			$table->integer('company_id');
			$table->enum('visibility', array(''INTERNAL'', ''EXTERNAL'', ''BOTH''));
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}