<?php

namespace  App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notification';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function courriers()
	{
		return $this->hasMany('Courrier');
	}

	public function utilisateurs()
	{
		return $this->belongsToMany(' App\Models\Utilisateur');
	}

}